"""Multiresponse linear regression with weights."""

import numpy as np
from sklearn.linear_model import LinearRegression


def weighted_linreg(matrix, weight, left_factor):
  """Multiresponse linear regression with weights."""
  reg = LinearRegression(fit_intercept=False)
  right_factor = []
  for j in range(weight.shape[1]):
    weight_j = weight[:, j][..., np.newaxis]
    reg.fit(weight_j * left_factor, weight_j * matrix[:, j][..., np.newaxis])
    right_factor += [reg.coef_[0, :]]
  return np.transpose(np.array(right_factor))
